// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AHMTScheduler.pas' rev: 3.00

#ifndef AHMTSchedulerHPP
#define AHMTSchedulerHPP
#include <AHMSystemConst.hpp>
#include <AHMSystemClass.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Ahmtscheduler
{
//-- type declarations -------------------------------------------------------
enum TAHMTriggerDaysGroup { Mon, Tue, Wed, Thu, Fri, Sat, Sun };

typedef Set<TAHMTriggerDaysGroup, Mon, Sun>  TAHMTriggerDays;

typedef void __fastcall (__closure *TAHMOnTrigger)(System::TObject* Sender, const System::AnsiString 
	ScheduleID, bool &Active);

class DELPHICLASS TAHMScheduledTimerThread;
class DELPHICLASS TAHMScheduledTimer;
class PASCALIMPLEMENTATION TAHMScheduledTimer : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool FEnabled;
	Word FInterval;
	Classes::TNotifyEvent FOnTimer;
	TAHMScheduledTimerThread* FTimerThread;
	TThreadPriority FThreadPriority;
	void __fastcall SetEnabled(const bool Value);
	void __fastcall SetInterval(const Word Value);
	void __fastcall SetThreadPriority(const Classes::TThreadPriority Value);
	
protected:
	void __fastcall UpdateTimer(void);
	DYNAMIC void __fastcall Timer(void);
	
public:
	__fastcall virtual TAHMScheduledTimer(void);
	__fastcall virtual ~TAHMScheduledTimer(void);
	
__published:
	__property bool Enabled = {read=FEnabled, write=SetEnabled, nodefault};
	__property Word Interval = {read=FInterval, write=SetInterval, default=200};
	__property Classes::TNotifyEvent OnTimer = {read=FOnTimer, write=FOnTimer};
	__property Classes::TThreadPriority Priority = {read=FThreadPriority, write=SetThreadPriority, nodefault
		};
};

class PASCALIMPLEMENTATION TAHMScheduledTimerThread : public Classes::TThread 
{
	typedef Classes::TThread inherited;
	
public:
	TAHMScheduledTimer* OwnerTimer;
	virtual void __fastcall Execute(void);
	void __fastcall DoTimer(void);
public:
	/* TThread.Create */ __fastcall TAHMScheduledTimerThread(bool CreateSuspended) : Classes::TThread(CreateSuspended
		) { }
	/* TThread.Destroy */ __fastcall virtual ~TAHMScheduledTimerThread(void) { }
	
};

class DELPHICLASS TAHMScheduledTime;
class DELPHICLASS TAHMScheduler;
class DELPHICLASS TAHMSchedules;
class PASCALIMPLEMENTATION TAHMSchedules : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TAHMScheduler* FAHMScheduler;
	TAHMScheduledTime* __fastcall GetAHMScheduledTime(int Index);
	void __fastcall SetAHMScheduledTime(int Index, TAHMScheduledTime* Value);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
public:
	__fastcall TAHMSchedules(TAHMScheduler* AOwner);
	HIDESBASE TAHMScheduledTime* __fastcall Add(void);
	bool __fastcall Delete(int Index);
	__property TAHMScheduler* Owner = {read=FAHMScheduler};
	__property TAHMScheduledTime* Items[int Index] = {read=GetAHMScheduledTime, write=SetAHMScheduledTime
		/*, default*/};
public:
	/* TCollection.Destroy */ __fastcall virtual ~TAHMSchedules(void) { }
	
};

class PASCALIMPLEMENTATION TAHMScheduler : public Ahmsystemclass::TAHMSystemsComponent 
{
	typedef Ahmsystemclass::TAHMSystemsComponent inherited;
	
private:
	TAHMSchedules* FAHMSchedules;
	bool FEnabled;
	TAHMOnTrigger FBeforeAnyTrigger;
	TAHMOnTrigger FAfterAnyTrigger;
	void __fastcall SetAHMSchedules(TAHMSchedules* Value);
	
public:
	__fastcall virtual TAHMScheduler(Classes::TComponent* AOwner);
	__fastcall virtual ~TAHMScheduler(void);
	
__published:
	__property About ;
	__property TAHMSchedules* Schedules = {read=FAHMSchedules, write=SetAHMSchedules};
	__property bool Enabled = {read=FEnabled, write=FEnabled, default=1};
	__property TAHMOnTrigger BeforeAnyTrigger = {read=FBeforeAnyTrigger, write=FBeforeAnyTrigger};
	__property TAHMOnTrigger AfterAnyTrigger = {read=FAfterAnyTrigger, write=FAfterAnyTrigger};
};

class PASCALIMPLEMENTATION TAHMScheduledTime : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TAHMScheduler* FAHMScheduler;
	bool FHasTriggered;
	TAHMScheduledTimer* FCurrentTimer;
	bool FActive;
	System::AnsiString FTriggerDate;
	System::AnsiString FTriggerTime;
	TAHMOnTrigger FOnTrigger;
	System::AnsiString FScheduleID;
	TAHMTriggerDays FAHMTriggerDays;
	void __fastcall SetActive(const bool Value);
	void __fastcall SetTriggerDate(const System::AnsiString Value);
	void __fastcall SetTriggerTime(const System::AnsiString Value);
	void __fastcall TimerActive(System::TObject* Sender);
	void __fastcall SetAHMTriggerdays(const TAHMTriggerDays Value);
	
protected:
	virtual System::AnsiString __fastcall GetDisplayName(void);
	
public:
	__fastcall virtual TAHMScheduledTime(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__fastcall virtual ~TAHMScheduledTime(void);
	__property TAHMScheduler* Owner = {read=FAHMScheduler};
	__property System::AnsiString DisplayName = {read=GetDisplayName};
	
__published:
	__property System::AnsiString TriggerDate = {read=FTriggerDate, write=SetTriggerDate};
	__property System::AnsiString TriggerTime = {read=FTriggerTime, write=SetTriggerTime};
	__property TAHMTriggerDays AllowDays = {read=FAHMTriggerDays, write=SetAHMTriggerdays, default=127}
		;
	__property System::AnsiString ScheduleID = {read=FScheduleID, write=FScheduleID};
	__property bool Active = {read=FActive, write=SetActive, default=0};
	__property TAHMOnTrigger OnTrigger = {read=FOnTrigger, write=FOnTrigger};
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE TTime __fastcall AHMAddToTime(TTime CTime, int Hours, int Minutes, int Seconds);
extern PACKAGE System::TDateTime __fastcall AHMAddToDateTime(System::TDateTime CDateTime, int Day, int 
	Hours, int Minutes, int Seconds);

}	/* namespace Ahmtscheduler */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Ahmtscheduler;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AHMTScheduler
